/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.api.constants.RoleType;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.global.GuiDialogEdit;
import noppes.npcs.client.gui.global.SubGuiNpcDialogOption;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.entity.EntityNPCInterface;

public class SubGuiNpcDialogOptions
extends SubGuiInterface
implements ICustomScrollListener,
ISubGuiListener,
GuiYesNoCallback {
    private final Dialog dialog;
    private final Map<String, Integer> data = new TreeMap<String, Integer>();
    private GuiCustomScroll scroll;
    public final GuiScreen parent;

    public SubGuiNpcDialogOptions(EntityNPCInterface npcIn, Dialog d, GuiScreen gui) {
        super(npcIn);
        this.setBackground("menubg.png");
        this.xSize = 256;
        this.ySize = 216;
        this.closeOnEsc = true;
        this.dialog = d;
        this.parent = gui;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                DialogOption option = new DialogOption();
                option.slot = this.dialog.options.size();
                this.dialog.options.put(option.slot, option);
                option.optionColor = SubGuiNpcDialogOption.LastColor;
                this.scroll.setSelect(option.slot);
                this.setSubGui(new SubGuiNpcDialogOption(option, this.parent));
                break;
            }
            case 1: {
                if (!this.data.containsKey(this.scroll.getSelected())) {
                    return;
                }
                DialogOption option = this.dialog.options.get(this.data.get(this.scroll.getSelected()));
                GuiYesNo guiyesno = new GuiYesNo((GuiYesNoCallback)this, "ID:" + option.slot + " - " + option.title, new TextComponentTranslation("gui.deleteMessage", new Object[0]).func_150254_d(), 0);
                this.displayGuiScreen((GuiScreen)guiyesno);
                break;
            }
            case 2: {
                if (!this.data.containsKey(this.scroll.getSelected())) {
                    return;
                }
                DialogOption option = this.dialog.options.get(this.data.get(this.scroll.getSelected()));
                if (option == null) break;
                this.setSubGui(new SubGuiNpcDialogOption(option, this.parent));
                break;
            }
            case 3: {
                if (!this.data.containsKey(this.scroll.getSelected())) {
                    return;
                }
                this.dialog.upPos(this.data.get(this.scroll.getSelected()));
                this.scroll.setSelect(this.scroll.getSelect() - 1);
                this.func_73866_w_();
                break;
            }
            case 4: {
                if (!this.data.containsKey(this.scroll.getSelected())) {
                    return;
                }
                this.dialog.downPos(this.data.get(this.scroll.getSelected()));
                this.scroll.setSelect(this.scroll.getSelect() + 1);
                this.func_73866_w_();
                break;
            }
            case 66: {
                this.close();
            }
        }
    }

    public void func_73878_a(boolean result, int id) {
        if (this.parent instanceof GuiDialogEdit && ((GuiDialogEdit)this.parent).parent != null) {
            NoppesUtil.openGUI((EntityPlayer)this.player, ((GuiDialogEdit)this.parent).parent);
        } else {
            NoppesUtil.openGUI((EntityPlayer)this.player, this);
        }
        if (!result) {
            return;
        }
        this.dialog.options.remove(this.data.get(this.scroll.getSelected()));
        this.func_73866_w_();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addLabel(new GuiNpcLabel(66, "dialog.options", this.guiLeft, this.guiTop + 4));
        this.getLabel(66).setCenter(this.xSize);
        this.data.clear();
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<Integer> colors = new ArrayList<Integer>();
        this.fix();
        DialogController dData = DialogController.instance;
        LinkedHashMap<Integer, List<String>> hts = new LinkedHashMap<Integer, List<String>>();
        for (int id : this.dialog.options.keySet()) {
            DialogOption option = this.dialog.options.get(id);
            String key = "\u00a77ID:" + id + " ";
            if (option == null) continue;
            switch (option.optionType) {
                case COMMAND_BLOCK: {
                    key = key + "\u00a7eC";
                    ArrayList<String> hovers = new ArrayList<String>();
                    hovers.add(new TextComponentTranslation("gui.type", new Object[0]).func_150254_d() + ": " + option.optionType.get() + " - " + '\u00a7' + "e" + option.optionType.name());
                    hovers.add(new TextComponentTranslation("quest.has." + !option.command.isEmpty(), new Object[0]).func_150254_d() + (!option.command.isEmpty() ? " - \"" + option.command + "\"" : ""));
                    hts.put(id, hovers);
                    break;
                }
                case DIALOG_OPTION: {
                    key = key + "\u00a73D";
                    ArrayList<String> hovers = new ArrayList();
                    hovers.add(new TextComponentTranslation("gui.type", new Object[0]).func_150254_d() + ": " + option.optionType.get() + " - " + '\u00a7' + "3" + option.optionType.name());
                    if (option.hasDialogs()) {
                        hovers.add(new TextComponentTranslation("availability.selectdialog", new Object[0]).func_150254_d() + ":");
                        for (DialogOption.OptionDialogID od : option.dialogs) {
                            String hd = "ID: " + od.dialogId + " -";
                            hd = dData.hasDialog(od.dialogId) ? hd + " \"" + new TextComponentTranslation(dData.get((int)od.dialogId).title, new Object[0]).func_150254_d() + "\" " + new TextComponentTranslation("quest.task.item.0", new Object[0]).func_150254_d() : hd + new TextComponentTranslation("quest.task.item.1", new Object[0]).func_150254_d();
                            hovers.add(hd);
                        }
                    } else {
                        hovers.add(new TextComponentTranslation("quest.has.false", new Object[0]).func_150254_d());
                    }
                    hts.put(id, hovers);
                    break;
                }
                case QUIT_OPTION: {
                    key = key + "\u00a7dE";
                    hts.put(id, Collections.singletonList(new TextComponentTranslation("gui.type", new Object[0]).func_150254_d() + ": " + option.optionType.get() + " - " + '\u00a7' + "d" + option.optionType.name()));
                    break;
                }
                case ROLE_OPTION: {
                    key = key + "\u00a7aR";
                    ArrayList<String> hovers = new ArrayList();
                    hovers.add(new TextComponentTranslation("gui.type", new Object[0]).func_150254_d() + ": " + option.optionType.get() + " - " + '\u00a7' + "a" + option.optionType.name());
                    hovers.add(new TextComponentTranslation("role.name", new Object[0]).func_150254_d() + " -" + new TextComponentTranslation("quest.task.item." + (this.npc != null && this.npc.advanced.roleInterface.getEnumType() != RoleType.DEFAULT ? "0" : "1"), new Object[0]).func_150254_d());
                    hts.put(id, hovers);
                    break;
                }
                case DISABLED: {
                    key = key + "\u00a74N";
                    hts.put(id, Collections.singletonList(new TextComponentTranslation("gui.type", new Object[0]).func_150254_d() + ": " + option.optionType.get() + " - " + '\u00a7' + "4" + option.optionType.name()));
                }
            }
            key = key + "\u00a77 - \"\u00a7r" + option.title + '\u00a7' + "7\"";
            colors.add(option.optionColor);
            this.data.put(key, id);
            list.add(key);
        }
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(248, 154);
        }
        this.scroll.setListNotSorted(list);
        this.scroll.setColors(colors);
        this.scroll.setHoverTexts(hts);
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 14;
        this.addScroll(this.scroll);
        this.addButton(new GuiNpcButton(0, this.guiLeft + 4, this.guiTop + 170, 48, 20, "gui.add"));
        this.addButton(new GuiNpcButton(1, this.guiLeft + 54, this.guiTop + 170, 48, 20, "gui.remove"));
        this.getButton(1).setEnabled(this.scroll.hasSelected());
        this.addButton(new GuiNpcButton(2, this.guiLeft + 104, this.guiTop + 170, 48, 20, "selectServer.edit"));
        this.getButton(2).setEnabled(this.scroll.hasSelected());
        this.addButton(new GuiNpcButton(3, this.guiLeft + 154, this.guiTop + 170, 48, 20, "type.up", this.scroll.getSelect() != -1 && this.scroll.getSelect() != 0));
        this.addButton(new GuiNpcButton(4, this.guiLeft + 204, this.guiTop + 170, 48, 20, "type.down", this.scroll.getSelect() != -1 && this.scroll.getSelect() > -1 && this.scroll.getSelect() < this.data.size() - 1));
        this.addButton(new GuiNpcButton(66, this.guiLeft + 82, this.guiTop + 192, 98, 20, "gui.done"));
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int time, IGuiCustomScroll scroll) {
        if (!this.data.containsKey(scroll.getSelected())) {
            scroll.setSelect(-1);
            return;
        }
        this.func_73866_w_();
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        if (!this.data.containsKey(scroll.getSelected())) {
            return;
        }
        DialogOption option = this.dialog.options.get(this.data.get(scroll.getSelected()));
        if (option == null) {
            return;
        }
        this.setSubGui(new SubGuiNpcDialogOption(option, this.parent));
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (this.parent instanceof GuiDialogEdit && ((GuiDialogEdit)this.parent).parent != null) {
            NoppesUtil.openGUI((EntityPlayer)this.player, ((GuiDialogEdit)this.parent).parent);
        }
        this.func_73866_w_();
    }

    private void fix() {
        TreeMap<Integer, DialogOption> map = new TreeMap<Integer, DialogOption>();
        int i = 0;
        boolean bo = false;
        for (int id : this.dialog.options.keySet()) {
            if (id != i) {
                bo = true;
            }
            DialogOption dlOp = this.dialog.options.get(id).copy();
            dlOp.slot = i;
            map.put(i, dlOp);
            ++i;
        }
        if (bo) {
            this.dialog.options.clear();
            this.dialog.options.putAll(map);
        }
    }
}

